<?php
/***************************************************************************
 *   awEventCalendar                                                       *
 *                                                                         *
 *   Copyright (C) 2006-2007 Artur Wiebe                                   *
 *   wibix@gmx.de                                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
if(!defined("IN_FUSION") || !checkrights("IP")) {
	header("Location: ../index.php");
	exit;
}


$mysql = array();


switch($ec_settings['version']) {
case "0.2.0":
case "0.3.0":
	$newver = "0.3.5";
	$mysql[] = "ALTER TABLE ".DB_PREFIX."aw_ec_events"
		." ADD COLUMN ev_login_limit tinyint(1) unsigned NOT NULL default '0'";
	$mysql[] = "ALTER TABLE ".DB_PREFIX."aw_ec_events"
		." CHANGE COLUMN ev_rep_year ev_repeat tinyint(1) unsigned NOT NULL default '0'";
	break;


case "0.3.5":
case "0.4.1":
	$newver = "0.3.7";
	// events table
	$mysql[] = "ALTER TABLE ".DB_PREFIX."aw_ec_events"
		." ADD COLUMN ev_show_time tinyint(1) unsigned NOT NULL default '0'";
	// settings table
	$mysql[] = "ALTER TABLE ".DB_PREFIX."aw_ec_settings"
		." ADD COLUMN birthday_date_format varchar(50) NOT NULL default '%d.%m.%Y'";
	$mysql[] = "ALTER TABLE ".DB_PREFIX."aw_ec_settings"
		." ADD COLUMN ballon_w smallint(5) unsigned NOT NULL default '200'";
	$mysql[] = "ALTER TABLE ".DB_PREFIX."aw_ec_settings"
		." ADD COLUMN ballon_fg char(7) NOT NULL default '#000000'";
	$mysql[] = "ALTER TABLE ".DB_PREFIX."aw_ec_settings"
		." ADD COLUMN ballon_bg char(7) NOT NULL default '#ffcc00'";
	break;


case "0.3.7":
	$newver = "0.3.9";
	//
	$mysql[] = "ALTER TABLE ".DB_PREFIX."aw_ec_settings"
		." DROP PRIMARY KEY, DROP COLUMN set_id";
	break;


case "0.3.9":
	$newver = "0.5.0";
	break;

case "0.5.0":
case "0.5.1":
case "0.5.2":
	$newver = "0.5.3";
	//
	$mysql[] = "UPDATE ".DB_PREFIX."aw_ec_events SET ev_end=ev_start";
	break;

case "0.5.3":
case "0.5.4":
	$newver = "0.5.5";
	//
	@mysql_query("ALTER TABLE ".DB_PREFIX."aw_ec_events"
		." DROP COLUMN ev_login_access");
	$mysql[] = "ALTER TABLE ".DB_PREFIX."aw_ec_events"
		." ADD COLUMN ev_login_access tinyint(3) unsigned NOT NULL default '101'";
	break;

case "0.5.5":
	$newver = "0.5.6";
	//
	$mysql[] = "ALTER TABLE ".DB_PREFIX."aw_ec_settings"
		." CHANGE COLUMN birthday_date_format birthdate_fmt varchar(50) NOT NULL default '%d.%m.%Y'";
	$mysql[] = "ALTER TABLE ".DB_PREFIX."aw_ec_settings"
		." ADD COLUMN date_fmt varchar(50) NOT NULL default '%d.%m.%Y'";
	break;

case "0.5.6":
	$newver = "0.5.7";
	break;

case "0.5.7":
default:
	unset($newver);
	break;
}

if(!isset($newver)) {
	return;
}


$do_update = (isset($_GET['do_update']) && $_GET['do_update']==1);
if($do_update) {
	$errors = 0;
	$val = 0;
	$button = $locale['EC804'];
} else {
	$val = 1;
	$button = $locale['EC802'];
}


echo "<p><b>".$locale['EC800'].": </b>"
	.$ec_settings['version']." -&gt; ".$newver;
echo "<p>".$locale['EC801'].":<div class='textbox' style='overflow:auto;'><ul>\n";
foreach($mysql as $query) {
	if($do_update) {
		if(dbquery($query)) {
			$ok = "<span class='small2'>".$locale['EC805']
				."</span> - ";
		} else {
			$ok = "<b>".$locale['EC806']."</b> - ";
			$errors++;
		}
	} else {
		$ok = "";
	}
	echo "<li>$ok<code>$query</code></li>\n";
}
echo "</ul></div>\n";

if($do_update) {
	if($errors) {
		echo "<p><b>".$locale['EC806'].":</b> ".$errors;
	} else {
		dbquery("UPDATE ".DB_PREFIX."aw_ec_settings"
			." SET version='$newver'");
	}

}

echo "<p>
<form method='get' action='".FUSION_SELF."'>
<input type='hidden' name='do_update' value='$val'>
<input type='submit' class='button' value='$button'>
</form>
<hr>\n";

?>
