<?php
/*---------------------------------------------------+
| PHP-Fusion 6 Content Management System
+----------------------------------------------------+
| Copyright  2002 - 2006 Nick Jones
| http://www.php-fusion.co.uk/
+----------------------------------------------------+
| Released under the terms & conditions of v2 of the
| GNU General Public License. For details refer to
| the included gpl.txt file or visit http://gnu.org
+----------------------------------------------------+
| Modified by PHP-Fusion SF Group
| Copyright  2007 by SF
| http://www.rus-phpfusion.com/
+----------------------------------------------------*/
require_once "../../maincore.php";
require_once BASEDIR."subheader.php";
require_once BASEDIR."side_left.php";
include LOCALE.LOCALESET."forum/main.php";

if (file_exists(INFUSIONS."forum_threads_list_panel/locale/".$settings['locale'].".php")) {
	include INFUSIONS."forum_threads_list_panel/locale/".$settings['locale'].".php";
} else {
	include INFUSIONS."forum_threads_list_panel/locale/English.php";
}

if (!iMEMBER) fallback("index.php");

opentable($locale['UAFT_001']);
	// First get all threads without a reply
	$rows = dbrows(dbquery("SELECT count(thread_id), thread_id, forum_id, post_subject, post_author, post_datestamp
					FROM ".$db_prefix."posts
					GROUP BY thread_id 
					HAVING count(thread_id) = 1"
				));

	if (!$rowstart) $rowstart = 0;

	echo "<div style='text-align:center; margin-top:5px;'>
	".makePageNav($rowstart,20,$rows,3,"$PHP_SELF?")."
	</div>\n";


	$query = "SELECT count(thread_id), thread_id, forum_id, post_subject, post_author, post_datestamp
					FROM ".$db_prefix."posts
					GROUP BY thread_id 
					HAVING count(thread_id) = 1
					LIMIT $rowstart,20
			";

	$result = dbquery($query);
	$numrows = dbrows($result);

	// Only display unanswered threads
	if ($numrows != 0) {

		// Display headings
		echo "<br />				<table class='tbl-border' border='0' cellspacing='1' cellpadding='2' width='100%'>
				<tr>
					<td style='text-align:center;' class='tbl2'>&nbsp;</td>
					<td style='text-align:center;' class='tbl2'><span class='small'><b>".$locale['UAFT_002']."</b></span></td>
					<td style='text-align:center;' class='tbl2'><span class='small'><b>".$locale['UAFT_003']."</b></span></td>
					<td style='text-align:center;' class='tbl2' width='100'><span class='small'><b>".$locale['UAFT_004']."</b></span></td>
					<td style='text-align:center;' class='tbl2' width='120'><span class='small'><b>".$locale['UAFT_005']."</b></span></td>
		</tr>\n";

				// Loop through each thread
				while ($data = dbarray($result)) {

					// Get forum details
					$result2 = dbquery("SELECT forum_name, forum_access, forum_id, forum_cat
										FROM ".$db_prefix."forums
										WHERE forum_id='".$data['forum_id']."'"
								);

					$data2 = dbarray($result2);

					// Get forum category details
					$result3 = dbquery("SELECT forum_name
										FROM ".$db_prefix."forums
										WHERE forum_id='".$data2['forum_cat']."'"
								);

					$forum_cat = dbresult($result3,0);

					// Check if user has access to this forum
					if (checkgroup($data2['forum_access'])) {

						// Lookup username
						$result3 = dbquery("SELECT user_name FROM ".$db_prefix."users WHERE user_id='".$data['post_author']."'");
						$username = dbresult($result3,0);

						// Display threads
						echo "<tr>
						<td class='tbl1'><img alt='' border='0' src='".BASEDIR."infusions/forum_threads_list_panel/images/unanswered.gif'>
                        </td>
						<td class='tbl1'><a href='".BASEDIR."forum/viewthread.php?forum_id=".$data['forum_id']."&amp;thread_id=".$data['thread_id']."'>".$data['post_subject']."</a></td>
						<td class='tbl1'>
                        <a href='".BASEDIR."forum/viewforum.php?forum_id=".$data2['forum_id']."&amp;forum_cat=".$data2['forum_cat']."'>".$data2['forum_name']."</a> [".$forum_cat."]</td>
						<td style='text-align:center;' class='tbl1'>
                        <a href='".BASEDIR."profile.php?lookup=".$data['post_author']."'>".$username."</a></td>
						<td style='text-align:center;' class='tbl1'>".strftime($settings['forumdate'],
						$data['post_datestamp']+($settings['timeoffset']*3600))."</td>
						</tr>\n";
					}
				}

			echo "</table>
			<br />\n";

		echo "<div style='vertical-align:top; text-align:center'><img alt='' border='0' src='".THEME."images/bullet.gif'>&nbsp;<a class='small' href='".BASEDIR."index.php'><b>  </b></a>&nbsp;&nbsp;&nbsp;<img alt='' border='0' src='".THEME."images/bullet.gif'>&nbsp;<a class='small' href='".BASEDIR."forum/index.php'><b>  </b></a></div><div style='text-align:center; margin-top:5px;'>
		".makePageNav($rowstart,20,$rows,3,"$PHP_SELF?")."
		</div><br />\n";
		
	} else {

		// No posts have gone unanswered
		echo "<div style='text-align:center;'><br />".$locale['UAFT_006']."<br /><br /></div>\n";

	}

closetable();

require_once BASEDIR."side_right.php";
require_once BASEDIR."footer.php";
?>