<?php
/*---------------------------------------------------+
| PHP-Fusion 6 Content Management System
+----------------------------------------------------+
| Copyright  2002 - 2006 Nick Jones
| http://www.php-fusion.co.uk/
+----------------------------------------------------+
| Released under the terms & conditions of v2 of the
| GNU General Public License. For details refer to
| the included gpl.txt file or visit http://gnu.org
+----------------------------------------------------*/
if (!defined("IN_FUSION")) { header("Location:../../index.php"); exit; }

require_once INCLUDES."countries.php";

if (file_exists(INFUSIONS."member_location_panel/locale/".$settings['locale'].".php")) {
	include INFUSIONS."member_location_panel/locale/".$settings['locale'].".php";
} else { include INFUSIONS."member_location_panel/locale/English.php"; }

$maxLength = 15;	// Maximum number of characters in country names
$minCountries = 5;	// Minimum number of countries to show in first level
$maxCountries = 10;	// Maximum number of countries to show in second level (hidden)

echo "<script type='text/javascript'>
<!--
function toggle_mlp() {
	var mlp = document.getElementById('mlp');
	var mlptxt = document.getElementById('mlp_text');
	if (mlp.style.display == 'none') {
		mlp.style.display = 'block';
		mlptxt.innerHTML = '".$locale['MLP_003']."';
	} else {
		mlp.style.display = 'none';
		mlptxt.innerHTML = '".$locale['MLP_002']."';
	}
}
//-->
</script>";

openside($locale['MLP_000']);

$result = dbquery("SELECT COUNT(user_id) as total, user_location FROM ".$db_prefix."users
	WHERE user_location != '' GROUP BY user_location ORDER BY total DESC, user_location
	LIMIT ".($minCountries + $maxCountries)
);
if (dbrows($result) != 0) {
	$mlp_count = 0;
	echo "<table width='100%' cellpadding='0' cellspacing='1' align='center' class='tbl-border'>\n";
	while($data = dbarray($result)) {
		if ($mlp_count == $minCountries) {
			echo "</table>
<br>
<div align='center'>
<img alt='' border='0' src='".THEME."images/bullet.gif'>&nbsp;
<a href=\"javascript:void(0)\" onClick=\"toggle_mlp();\"><span id='mlp_text'>".$locale['MLP_002']."</span></a>&nbsp;
<img alt='' border='0' src='".THEME."images/bulletb.gif'>
</div>
<div id='mlp' style='display: none;'>
<br>
<table width='100%' cellpadding='0' cellspacing='1' align='center' class='tbl-border'>\n";
		}
		$mlp_country = csm_getCountry($data['user_location']);
		$mlp_flag = csm_getFlag($data['user_location']);
		echo "<tr>
<td class='tbl2'><a href='".BASEDIR."members.php?sortby=location&amp;country=".$data['user_location']."' title='$mlp_country'>$mlp_flag ".trimlink($mlp_country, $maxLength)."</a></td>
<td align='center' class='tbl2' style='white-space:nowrap'><b>".$data['total']."</b></td>
</tr>\n";
		$mlp_count ++;
	}
	echo "</table>
<br>
<div align='center'>
<img alt='' border='0' src='".THEME."images/bullet.gif'>&nbsp;
<a href='".INFUSIONS."member_location_panel/member_location_list.php'>".$locale['MLP_004']."</a>&nbsp;
<img alt='' border='0' src='".THEME."images/bulletb.gif'>
</div>\n";
	if ($mlp_count > $minCountries) { echo "</div>\n"; }
} else { echo "<center>".$locale['MLP_001']."</center>"; }

closeside();

?>